create or replace function createtable() 
returns void as 
$body$ 
begin  
  
if not  exists (select 1 from information_schema.columns a 
			     where table_name ='est_orc') then 
CREATE TABLE public.est_orc
(
    cd_emp integer NOT NULL DEFAULT 0,
    cd_filial integer NOT NULL DEFAULT 0,
    cd_orc integer NOT NULL DEFAULT 0,
    cd_conv integer,
    cd_cli integer,
    dt_emi timestamp without time zone,
    vlr_tot numeric(10,2),
    vlr_prod numeric(10,2),
    vlr_desc numeric(10,2),
    vlr_desc_geral numeric(10,2),
    obs character varying(400) COLLATE pg_catalog."default" NOT NULL DEFAULT ''::character varying,
    cd_nt_mov integer,
    cd_vend_lib integer,
    hora_entr character varying(50) COLLATE pg_catalog."default",
    ender_entg character varying(150) COLLATE pg_catalog."default",
    bairro_entg character varying(50) COLLATE pg_catalog."default",
    cd_cid_entg integer,
    cep_entg character varying(50) COLLATE pg_catalog."default",
    ponto_ref_entg character varying(150) COLLATE pg_catalog."default",
    hora_entr_combinado character varying(50) COLLATE pg_catalog."default",
    orig_orc integer DEFAULT 0,
    sts_ent integer,
    hora_entr_real character varying(50) COLLATE pg_catalog."default",
    nr_cartao_fidelidade character varying(20) COLLATE pg_catalog."default" DEFAULT 0,
    nm_cli character varying(200) COLLATE pg_catalog."default",
    fone_cli character varying(25) COLLATE pg_catalog."default",
    cgc_cpf character varying(20) COLLATE pg_catalog."default",
    end_cli character varying(150) COLLATE pg_catalog."default",
    bairro character varying(50) COLLATE pg_catalog."default",
    cep character varying(20) COLLATE pg_catalog."default",
    cd_cid integer,
    nr_autr_pbm character varying(150) COLLATE pg_catalog."default" NOT NULL DEFAULT ''::character varying,
    cpf_cli_pbm character varying(50) COLLATE pg_catalog."default" NOT NULL DEFAULT ''::character varying,
    tipo_pbm integer NOT NULL DEFAULT '-1'::integer,
    dt_receita_pbm timestamp without time zone,
    tel_cliente character varying(30) COLLATE pg_catalog."default",
    vlr_troco_entrega numeric(12,2) DEFAULT 0,
    nr_ped_televd numeric(10,0) DEFAULT 0,
    vd_troca_fidel numeric(1,0) DEFAULT 0,
    tipo_prazo_pgto numeric(1,0) DEFAULT 0,
    tp_orc_entg numeric(1,0) DEFAULT 0,
    tp_hora_entr integer,
    nr_cartao_pbm character varying(50) COLLATE pg_catalog."default" DEFAULT ''::character varying,
    cd_projeto_pbm character varying COLLATE pg_catalog."default" DEFAULT ''::character varying,
    flag_imp_comp numeric(1,1) DEFAULT 0,
    id_crm_cro numeric(1,0) DEFAULT 0,
    crm_cro numeric(12,0) DEFAULT 0,
    uf_crm_cro character varying(2) COLLATE pg_catalog."default" DEFAULT ' '::character varying,
    cd_dependente_pbm character varying(50) COLLATE pg_catalog."default",
    nr_rg_dependente_pbm character varying(30) COLLATE pg_catalog."default",
    modalidade_pbm character varying(20) COLLATE pg_catalog."default",
    nr_coo numeric(6,0) DEFAULT 0,
    cd_orc_nv numeric(6,0) DEFAULT 0,
    offline integer NOT NULL DEFAULT 0,
    cd_frm_pgto integer NOT NULL DEFAULT 0,
    flag_consolidado integer DEFAULT 0,
    perc_rec_conv numeric(10,4) DEFAULT 0,
    tp_perc_rec_conv integer DEFAULT 0,
    nm_comprador character varying(100) COLLATE pg_catalog."default",
    dados_adicionais text COLLATE pg_catalog."default",
    qt_parc_conv numeric(2,0) DEFAULT 0,
    usu_nm_farm_popular character varying(11) COLLATE pg_catalog."default",
    usu_sh_farm_popular character varying(8) COLLATE pg_catalog."default",
    entrega_balcao boolean DEFAULT false,
    cd_sol_pbm numeric DEFAULT 0,
    tp_orc integer DEFAULT 0,
    hr_emi timestamp without time zone,
    cd_cx numeric(6,0) NOT NULL DEFAULT 0,
    qtd_dias_prorrog integer NOT NULL DEFAULT 0,
    vlr_cartao numeric(10,2) DEFAULT 0,
    vlr_cheque numeric(10,2) DEFAULT 0,
    cd_cli_dep numeric,
    cd_cx_canc_paf integer NOT NULL DEFAULT 0,
    flag_contem_campanha integer DEFAULT 0,
    sts_orc character varying(32) COLLATE pg_catalog."default" NOT NULL DEFAULT 0,
    cond_pgto integer,
    complemento_entg character varying(200) COLLATE pg_catalog."default" NOT NULL DEFAULT ''::character varying,
    nr_receita_pbm numeric(12,0),
    versao character varying(15) COLLATE pg_catalog."default" NOT NULL DEFAULT ''::character varying,
    dt_alt_orc timestamp without time zone,
    tipo_venda_fidelize integer NOT NULL DEFAULT 0,
    nr_cartao_fidelize character varying(20) COLLATE pg_catalog."default",
    nr_ecf_uuid character varying(256) COLLATE pg_catalog."default",
    vlr_frete_tot numeric(14,4) NOT NULL DEFAULT 0,
    flag_somente_desc_contrato numeric(1,0) DEFAULT 0,
    nsu_vnd character varying(100) COLLATE pg_catalog."default" DEFAULT ''::character varying,
    utiliza_desc_propz numeric(1,0) DEFAULT 0,
    vlr_desc_sub_total_crescevendas numeric(14,2) NOT NULL DEFAULT 0,
    comunica_api_parceiro integer,
    cpf_desconto_parceiro character varying(20) COLLATE pg_catalog."default",
    nome_desconto_parceiro character varying(150) COLLATE pg_catalog."default",
    senha_servidor_consignet character varying(50) COLLATE pg_catalog."default",
    protocolo_merck character varying(20) COLLATE pg_catalog."default",
    validade_merck date,
    adquirente character varying(255) COLLATE pg_catalog."default",
    endr_entg character varying(150) COLLATE pg_catalog."default",
    venda_sem_comunicacao_consignet integer NOT NULL DEFAULT 0,
    ind_etq_impressa integer DEFAULT 0,
    CONSTRAINT est_orc_pkey PRIMARY KEY (cd_emp, cd_filial, cd_orc)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.est_orc
    OWNER to postgres;

COMMENT ON COLUMN public.est_orc.tp_orc
    IS '0 - Balcao
1 - Televendas
2 - Cotacao';

COMMENT ON COLUMN public.est_orc.endr_entg
    IS 'Campo utilizado para informação de endereço de entrega do cliente';

COMMENT ON COLUMN public.est_orc.ind_etq_impressa
    IS 'indica se ja foi impresso etiqueta de receita deste orcamento';
-- Index: est_orc_idx

-- DROP INDEX public.est_orc_idx;

CREATE INDEX est_orc_idx
    ON public.est_orc USING btree
    (cd_orc ASC NULLS LAST, cd_filial ASC NULLS LAST, cd_emp ASC NULLS LAST)
    TABLESPACE pg_default;
-- Index: est_orc_ix

-- DROP INDEX public.est_orc_ix;

CREATE INDEX est_orc_ix
    ON public.est_orc USING btree
    (dt_emi ASC NULLS LAST, cd_filial ASC NULLS LAST, cd_emp ASC NULLS LAST)
    TABLESPACE pg_default;
-- Index: ix_est_orc_flag_consolidado

-- DROP INDEX public.ix_est_orc_flag_consolidado;

CREATE INDEX ix_est_orc_flag_consolidado
    ON public.est_orc USING btree
    (flag_consolidado ASC NULLS LAST)
    TABLESPACE pg_default;

	raise notice 'tabela criada';                             
        
    else 
		 raise notice 'tabela ja existe';
    end if; 
	
	
end; 
-- fim bloco principal 
$body$ 
language plpgsql volatile 
  cost 100; 
alter function createtable() owner to postgres; 
select createtable(); 
drop function createtable();

